
# makefile for panorama stitching, created by hugin using the new makefilelib

# Force using cmd.exe
SHELL=C:\WINDOWS\system32\cmd.exe

# Tool configuration
NONA="O:/Program Files/Hugin 2012.0.0/bin/nona"
PTSTITCHER="PTStitcher"
PTMENDER="O:/Program Files/Hugin 2012.0.0/bin/PTmender"
PTBLENDER="O:/Program Files/Hugin 2012.0.0/bin/PTblender"
PTMASKER="O:/Program Files/Hugin 2012.0.0/bin/PTmasker"
PTROLLER="O:/Program Files/Hugin 2012.0.0/bin/PTroller"
ENBLEND="O:/Program Files/Hugin 2012.0.0/bin/enblend"
ENFUSE="O:/Program Files/Hugin 2012.0.0/bin/enfuse"
SMARTBLEND="smartblend.exe"
HDRMERGE="O:/Program Files/Hugin 2012.0.0/bin/hugin_hdrmerge"
RM=del
EXIFTOOL="O:/Program Files/Hugin 2012.0.0/bin/exiftool"

# Project parameters
HUGIN_PROJECTION=2
HUGIN_HFOV=360
HUGIN_WIDTH=5000
HUGIN_HEIGHT=2500

# options for the programs
NONA_LDR_REMAPPED_COMP=-z LZW
NONA_OPTS=-g 
ENBLEND_OPTS=--no-ciecam -w -f5000x2500
ENBLEND_LDR_COMP=--compression=LZW
ENBLEND_EXPOSURE_COMP=--compression=LZW
ENBLEND_HDR_COMP=
HDRMERGE_OPTS=-m avg -c
ENFUSE_OPTS= -w
EXIFTOOL_COPY_ARGS=-ImageDescription -Make -Model -Artist -WhitePoint -Copyright -GPS:all -DateTimeOriginal -CreateDate -UserComment -ColorSpace -OwnerName -SerialNumber
EXIFTOOL_INFO_ARGS="-Software=Hugin 2012.0.0.a6e4184ad538 built by Matthew Petroff" "-UserComment<$${UserComment}&\#xd;&\#xa;Projection: Equirectangular (2)&\#xd;&\#xa;FOV: 360 x 180&\#xd;&\#xa;Ev: 0.04" -f

# the output panorama
LDR_REMAPPED_PREFIX=Bild01-Bild16
LDR_REMAPPED_PREFIX_SHELL="Bild01-Bild16"
HDR_STACK_REMAPPED_PREFIX=Bild01-Bild16_hdr_
HDR_STACK_REMAPPED_PREFIX_SHELL="Bild01-Bild16_hdr_"
LDR_EXPOSURE_REMAPPED_PREFIX=Bild01-Bild16_exposure_layers_
LDR_EXPOSURE_REMAPPED_PREFIX_SHELL="Bild01-Bild16_exposure_layers_"
PROJECT_FILE=D:/Panoramen/test_halle/Bild01-Bild16.pto
PROJECT_FILE_SHELL="D:/Panoramen/test_halle/Bild01-Bild16.pto"
LDR_BLENDED=Bild01-Bild16.tif
LDR_BLENDED_SHELL="Bild01-Bild16.tif"
LDR_STACKED_BLENDED=Bild01-Bild16_fused.tif
LDR_STACKED_BLENDED_SHELL="Bild01-Bild16_fused.tif"
LDR_EXPOSURE_LAYERS_FUSED=Bild01-Bild16_blended_fused.tif
LDR_EXPOSURE_LAYERS_FUSED_SHELL="Bild01-Bild16_blended_fused.tif"
HDR_BLENDED=Bild01-Bild16_hdr.exr
HDR_BLENDED_SHELL="Bild01-Bild16_hdr.exr"

# first input image
INPUT_IMAGE_1=D:/Panoramen/test_halle/Bild01.jpg
INPUT_IMAGE_1_SHELL="D:/Panoramen/test_halle/Bild01.jpg"

# all input images
INPUT_IMAGES=D:/Panoramen/test_halle/Bild01.jpg\
D:/Panoramen/test_halle/Bild02.jpg\
D:/Panoramen/test_halle/Bild03.jpg\
D:/Panoramen/test_halle/Bild04.jpg\
D:/Panoramen/test_halle/Bild05.jpg\
D:/Panoramen/test_halle/Bild06.jpg\
D:/Panoramen/test_halle/Bild07.jpg\
D:/Panoramen/test_halle/Bild08.jpg\
D:/Panoramen/test_halle/Bild09.jpg\
D:/Panoramen/test_halle/Bild10.jpg\
D:/Panoramen/test_halle/Bild11.jpg\
D:/Panoramen/test_halle/Bild12.jpg\
D:/Panoramen/test_halle/Bild13.jpg\
D:/Panoramen/test_halle/Bild14.jpg
INPUT_IMAGES_SHELL="D:/Panoramen/test_halle/Bild01.jpg"\
"D:/Panoramen/test_halle/Bild02.jpg"\
"D:/Panoramen/test_halle/Bild03.jpg"\
"D:/Panoramen/test_halle/Bild04.jpg"\
"D:/Panoramen/test_halle/Bild05.jpg"\
"D:/Panoramen/test_halle/Bild06.jpg"\
"D:/Panoramen/test_halle/Bild07.jpg"\
"D:/Panoramen/test_halle/Bild08.jpg"\
"D:/Panoramen/test_halle/Bild09.jpg"\
"D:/Panoramen/test_halle/Bild10.jpg"\
"D:/Panoramen/test_halle/Bild11.jpg"\
"D:/Panoramen/test_halle/Bild12.jpg"\
"D:/Panoramen/test_halle/Bild13.jpg"\
"D:/Panoramen/test_halle/Bild14.jpg"

# remapped images
LDR_LAYERS=Bild01-Bild160000.tif\
Bild01-Bild160001.tif\
Bild01-Bild160002.tif\
Bild01-Bild160003.tif\
Bild01-Bild160004.tif\
Bild01-Bild160005.tif\
Bild01-Bild160006.tif\
Bild01-Bild160007.tif\
Bild01-Bild160008.tif\
Bild01-Bild160009.tif\
Bild01-Bild160010.tif\
Bild01-Bild160011.tif\
Bild01-Bild160012.tif\
Bild01-Bild160013.tif
LDR_LAYERS_SHELL="Bild01-Bild160000.tif"\
"Bild01-Bild160001.tif"\
"Bild01-Bild160002.tif"\
"Bild01-Bild160003.tif"\
"Bild01-Bild160004.tif"\
"Bild01-Bild160005.tif"\
"Bild01-Bild160006.tif"\
"Bild01-Bild160007.tif"\
"Bild01-Bild160008.tif"\
"Bild01-Bild160009.tif"\
"Bild01-Bild160010.tif"\
"Bild01-Bild160011.tif"\
"Bild01-Bild160012.tif"\
"Bild01-Bild160013.tif"

# remapped images (hdr)
HDR_LAYERS=Bild01-Bild16_hdr_0000.exr\
Bild01-Bild16_hdr_0001.exr\
Bild01-Bild16_hdr_0002.exr\
Bild01-Bild16_hdr_0003.exr\
Bild01-Bild16_hdr_0004.exr\
Bild01-Bild16_hdr_0005.exr\
Bild01-Bild16_hdr_0006.exr\
Bild01-Bild16_hdr_0007.exr\
Bild01-Bild16_hdr_0008.exr\
Bild01-Bild16_hdr_0009.exr\
Bild01-Bild16_hdr_0010.exr\
Bild01-Bild16_hdr_0011.exr\
Bild01-Bild16_hdr_0012.exr\
Bild01-Bild16_hdr_0013.exr
HDR_LAYERS_SHELL="Bild01-Bild16_hdr_0000.exr"\
"Bild01-Bild16_hdr_0001.exr"\
"Bild01-Bild16_hdr_0002.exr"\
"Bild01-Bild16_hdr_0003.exr"\
"Bild01-Bild16_hdr_0004.exr"\
"Bild01-Bild16_hdr_0005.exr"\
"Bild01-Bild16_hdr_0006.exr"\
"Bild01-Bild16_hdr_0007.exr"\
"Bild01-Bild16_hdr_0008.exr"\
"Bild01-Bild16_hdr_0009.exr"\
"Bild01-Bild16_hdr_0010.exr"\
"Bild01-Bild16_hdr_0011.exr"\
"Bild01-Bild16_hdr_0012.exr"\
"Bild01-Bild16_hdr_0013.exr"

# remapped maxval images
HDR_LAYERS_WEIGHTS=Bild01-Bild16_hdr_0000_gray.pgm\
Bild01-Bild16_hdr_0001_gray.pgm\
Bild01-Bild16_hdr_0002_gray.pgm\
Bild01-Bild16_hdr_0003_gray.pgm\
Bild01-Bild16_hdr_0004_gray.pgm\
Bild01-Bild16_hdr_0005_gray.pgm\
Bild01-Bild16_hdr_0006_gray.pgm\
Bild01-Bild16_hdr_0007_gray.pgm\
Bild01-Bild16_hdr_0008_gray.pgm\
Bild01-Bild16_hdr_0009_gray.pgm\
Bild01-Bild16_hdr_0010_gray.pgm\
Bild01-Bild16_hdr_0011_gray.pgm\
Bild01-Bild16_hdr_0012_gray.pgm\
Bild01-Bild16_hdr_0013_gray.pgm
HDR_LAYERS_WEIGHTS_SHELL="Bild01-Bild16_hdr_0000_gray.pgm"\
"Bild01-Bild16_hdr_0001_gray.pgm"\
"Bild01-Bild16_hdr_0002_gray.pgm"\
"Bild01-Bild16_hdr_0003_gray.pgm"\
"Bild01-Bild16_hdr_0004_gray.pgm"\
"Bild01-Bild16_hdr_0005_gray.pgm"\
"Bild01-Bild16_hdr_0006_gray.pgm"\
"Bild01-Bild16_hdr_0007_gray.pgm"\
"Bild01-Bild16_hdr_0008_gray.pgm"\
"Bild01-Bild16_hdr_0009_gray.pgm"\
"Bild01-Bild16_hdr_0010_gray.pgm"\
"Bild01-Bild16_hdr_0011_gray.pgm"\
"Bild01-Bild16_hdr_0012_gray.pgm"\
"Bild01-Bild16_hdr_0013_gray.pgm"

# stacked hdr images
HDR_STACK_0=Bild01-Bild16_stack_hdr_0000.exr
HDR_STACK_0_SHELL="Bild01-Bild16_stack_hdr_0000.exr"
HDR_STACK_0_INPUT=Bild01-Bild16_hdr_0000.exr
HDR_STACK_0_INPUT_SHELL="Bild01-Bild16_hdr_0000.exr"
HDR_STACK_1=Bild01-Bild16_stack_hdr_0001.exr
HDR_STACK_1_SHELL="Bild01-Bild16_stack_hdr_0001.exr"
HDR_STACK_1_INPUT=Bild01-Bild16_hdr_0001.exr
HDR_STACK_1_INPUT_SHELL="Bild01-Bild16_hdr_0001.exr"
HDR_STACK_2=Bild01-Bild16_stack_hdr_0002.exr
HDR_STACK_2_SHELL="Bild01-Bild16_stack_hdr_0002.exr"
HDR_STACK_2_INPUT=Bild01-Bild16_hdr_0002.exr
HDR_STACK_2_INPUT_SHELL="Bild01-Bild16_hdr_0002.exr"
HDR_STACK_3=Bild01-Bild16_stack_hdr_0003.exr
HDR_STACK_3_SHELL="Bild01-Bild16_stack_hdr_0003.exr"
HDR_STACK_3_INPUT=Bild01-Bild16_hdr_0003.exr
HDR_STACK_3_INPUT_SHELL="Bild01-Bild16_hdr_0003.exr"
HDR_STACK_4=Bild01-Bild16_stack_hdr_0004.exr
HDR_STACK_4_SHELL="Bild01-Bild16_stack_hdr_0004.exr"
HDR_STACK_4_INPUT=Bild01-Bild16_hdr_0004.exr
HDR_STACK_4_INPUT_SHELL="Bild01-Bild16_hdr_0004.exr"
HDR_STACK_5=Bild01-Bild16_stack_hdr_0005.exr
HDR_STACK_5_SHELL="Bild01-Bild16_stack_hdr_0005.exr"
HDR_STACK_5_INPUT=Bild01-Bild16_hdr_0005.exr
HDR_STACK_5_INPUT_SHELL="Bild01-Bild16_hdr_0005.exr"
HDR_STACK_6=Bild01-Bild16_stack_hdr_0006.exr
HDR_STACK_6_SHELL="Bild01-Bild16_stack_hdr_0006.exr"
HDR_STACK_6_INPUT=Bild01-Bild16_hdr_0006.exr
HDR_STACK_6_INPUT_SHELL="Bild01-Bild16_hdr_0006.exr"
HDR_STACK_7=Bild01-Bild16_stack_hdr_0007.exr
HDR_STACK_7_SHELL="Bild01-Bild16_stack_hdr_0007.exr"
HDR_STACK_7_INPUT=Bild01-Bild16_hdr_0007.exr
HDR_STACK_7_INPUT_SHELL="Bild01-Bild16_hdr_0007.exr"
HDR_STACK_8=Bild01-Bild16_stack_hdr_0008.exr
HDR_STACK_8_SHELL="Bild01-Bild16_stack_hdr_0008.exr"
HDR_STACK_8_INPUT=Bild01-Bild16_hdr_0008.exr
HDR_STACK_8_INPUT_SHELL="Bild01-Bild16_hdr_0008.exr"
HDR_STACK_9=Bild01-Bild16_stack_hdr_0009.exr
HDR_STACK_9_SHELL="Bild01-Bild16_stack_hdr_0009.exr"
HDR_STACK_9_INPUT=Bild01-Bild16_hdr_0009.exr
HDR_STACK_9_INPUT_SHELL="Bild01-Bild16_hdr_0009.exr"
HDR_STACK_10=Bild01-Bild16_stack_hdr_0010.exr
HDR_STACK_10_SHELL="Bild01-Bild16_stack_hdr_0010.exr"
HDR_STACK_10_INPUT=Bild01-Bild16_hdr_0010.exr
HDR_STACK_10_INPUT_SHELL="Bild01-Bild16_hdr_0010.exr"
HDR_STACK_11=Bild01-Bild16_stack_hdr_0011.exr
HDR_STACK_11_SHELL="Bild01-Bild16_stack_hdr_0011.exr"
HDR_STACK_11_INPUT=Bild01-Bild16_hdr_0011.exr
HDR_STACK_11_INPUT_SHELL="Bild01-Bild16_hdr_0011.exr"
HDR_STACK_12=Bild01-Bild16_stack_hdr_0012.exr
HDR_STACK_12_SHELL="Bild01-Bild16_stack_hdr_0012.exr"
HDR_STACK_12_INPUT=Bild01-Bild16_hdr_0012.exr
HDR_STACK_12_INPUT_SHELL="Bild01-Bild16_hdr_0012.exr"
HDR_STACK_13=Bild01-Bild16_stack_hdr_0013.exr
HDR_STACK_13_SHELL="Bild01-Bild16_stack_hdr_0013.exr"
HDR_STACK_13_INPUT=Bild01-Bild16_hdr_0013.exr
HDR_STACK_13_INPUT_SHELL="Bild01-Bild16_hdr_0013.exr"
HDR_STACKS_NUMBERS=0 1 2 3 4 5 6 7 8 9 10 11 12 13 
HDR_STACKS=$(HDR_STACK_0) $(HDR_STACK_1) $(HDR_STACK_2) $(HDR_STACK_3) $(HDR_STACK_4) $(HDR_STACK_5) $(HDR_STACK_6) $(HDR_STACK_7) $(HDR_STACK_8) $(HDR_STACK_9) $(HDR_STACK_10) $(HDR_STACK_11) $(HDR_STACK_12) $(HDR_STACK_13) 
HDR_STACKS_SHELL=$(HDR_STACK_0_SHELL) $(HDR_STACK_1_SHELL) $(HDR_STACK_2_SHELL) $(HDR_STACK_3_SHELL) $(HDR_STACK_4_SHELL) $(HDR_STACK_5_SHELL) $(HDR_STACK_6_SHELL) $(HDR_STACK_7_SHELL) $(HDR_STACK_8_SHELL) $(HDR_STACK_9_SHELL) $(HDR_STACK_10_SHELL) $(HDR_STACK_11_SHELL) $(HDR_STACK_12_SHELL) $(HDR_STACK_13_SHELL) 

# number of image sets with similar exposure
LDR_EXPOSURE_LAYER_0=Bild01-Bild16_exposure_0000.tif
LDR_EXPOSURE_LAYER_0_SHELL="Bild01-Bild16_exposure_0000.tif"
LDR_EXPOSURE_LAYER_0_INPUT=Bild01-Bild16_exposure_layers_0000.tif\
Bild01-Bild16_exposure_layers_0001.tif\
Bild01-Bild16_exposure_layers_0002.tif\
Bild01-Bild16_exposure_layers_0003.tif\
Bild01-Bild16_exposure_layers_0004.tif\
Bild01-Bild16_exposure_layers_0005.tif\
Bild01-Bild16_exposure_layers_0006.tif\
Bild01-Bild16_exposure_layers_0007.tif\
Bild01-Bild16_exposure_layers_0008.tif\
Bild01-Bild16_exposure_layers_0009.tif\
Bild01-Bild16_exposure_layers_0010.tif\
Bild01-Bild16_exposure_layers_0011.tif\
Bild01-Bild16_exposure_layers_0012.tif\
Bild01-Bild16_exposure_layers_0013.tif
LDR_EXPOSURE_LAYER_0_INPUT_SHELL="Bild01-Bild16_exposure_layers_0000.tif"\
"Bild01-Bild16_exposure_layers_0001.tif"\
"Bild01-Bild16_exposure_layers_0002.tif"\
"Bild01-Bild16_exposure_layers_0003.tif"\
"Bild01-Bild16_exposure_layers_0004.tif"\
"Bild01-Bild16_exposure_layers_0005.tif"\
"Bild01-Bild16_exposure_layers_0006.tif"\
"Bild01-Bild16_exposure_layers_0007.tif"\
"Bild01-Bild16_exposure_layers_0008.tif"\
"Bild01-Bild16_exposure_layers_0009.tif"\
"Bild01-Bild16_exposure_layers_0010.tif"\
"Bild01-Bild16_exposure_layers_0011.tif"\
"Bild01-Bild16_exposure_layers_0012.tif"\
"Bild01-Bild16_exposure_layers_0013.tif"
LDR_EXPOSURE_LAYER_0_INPUT_PTMENDER=Bild01-Bild160000.tif\
Bild01-Bild160001.tif\
Bild01-Bild160002.tif\
Bild01-Bild160003.tif\
Bild01-Bild160004.tif\
Bild01-Bild160005.tif\
Bild01-Bild160006.tif\
Bild01-Bild160007.tif\
Bild01-Bild160008.tif\
Bild01-Bild160009.tif\
Bild01-Bild160010.tif\
Bild01-Bild160011.tif\
Bild01-Bild160012.tif\
Bild01-Bild160013.tif
LDR_EXPOSURE_LAYER_0_INPUT_PTMENDER_SHELL="Bild01-Bild160000.tif"\
"Bild01-Bild160001.tif"\
"Bild01-Bild160002.tif"\
"Bild01-Bild160003.tif"\
"Bild01-Bild160004.tif"\
"Bild01-Bild160005.tif"\
"Bild01-Bild160006.tif"\
"Bild01-Bild160007.tif"\
"Bild01-Bild160008.tif"\
"Bild01-Bild160009.tif"\
"Bild01-Bild160010.tif"\
"Bild01-Bild160011.tif"\
"Bild01-Bild160012.tif"\
"Bild01-Bild160013.tif"
LDR_EXPOSURE_LAYER_0_EXPOSURE=0.0384051
LDR_EXPOSURE_LAYERS_NUMBERS=0 
LDR_EXPOSURE_LAYERS=$(LDR_EXPOSURE_LAYER_0) 
LDR_EXPOSURE_LAYERS_SHELL=$(LDR_EXPOSURE_LAYER_0_SHELL) 
LDR_EXPOSURE_LAYERS_REMAPPED=Bild01-Bild16_exposure_layers_0000.tif\
Bild01-Bild16_exposure_layers_0001.tif\
Bild01-Bild16_exposure_layers_0002.tif\
Bild01-Bild16_exposure_layers_0003.tif\
Bild01-Bild16_exposure_layers_0004.tif\
Bild01-Bild16_exposure_layers_0005.tif\
Bild01-Bild16_exposure_layers_0006.tif\
Bild01-Bild16_exposure_layers_0007.tif\
Bild01-Bild16_exposure_layers_0008.tif\
Bild01-Bild16_exposure_layers_0009.tif\
Bild01-Bild16_exposure_layers_0010.tif\
Bild01-Bild16_exposure_layers_0011.tif\
Bild01-Bild16_exposure_layers_0012.tif\
Bild01-Bild16_exposure_layers_0013.tif
LDR_EXPOSURE_LAYERS_REMAPPED_SHELL="Bild01-Bild16_exposure_layers_0000.tif"\
"Bild01-Bild16_exposure_layers_0001.tif"\
"Bild01-Bild16_exposure_layers_0002.tif"\
"Bild01-Bild16_exposure_layers_0003.tif"\
"Bild01-Bild16_exposure_layers_0004.tif"\
"Bild01-Bild16_exposure_layers_0005.tif"\
"Bild01-Bild16_exposure_layers_0006.tif"\
"Bild01-Bild16_exposure_layers_0007.tif"\
"Bild01-Bild16_exposure_layers_0008.tif"\
"Bild01-Bild16_exposure_layers_0009.tif"\
"Bild01-Bild16_exposure_layers_0010.tif"\
"Bild01-Bild16_exposure_layers_0011.tif"\
"Bild01-Bild16_exposure_layers_0012.tif"\
"Bild01-Bild16_exposure_layers_0013.tif"

# stacked ldr images
LDR_STACK_0=Bild01-Bild16_stack_ldr_0000.tif
LDR_STACK_0_SHELL="Bild01-Bild16_stack_ldr_0000.tif"
LDR_STACK_0_INPUT=Bild01-Bild16_exposure_layers_0000.tif
LDR_STACK_0_INPUT_SHELL="Bild01-Bild16_exposure_layers_0000.tif"
LDR_STACK_1=Bild01-Bild16_stack_ldr_0001.tif
LDR_STACK_1_SHELL="Bild01-Bild16_stack_ldr_0001.tif"
LDR_STACK_1_INPUT=Bild01-Bild16_exposure_layers_0001.tif
LDR_STACK_1_INPUT_SHELL="Bild01-Bild16_exposure_layers_0001.tif"
LDR_STACK_2=Bild01-Bild16_stack_ldr_0002.tif
LDR_STACK_2_SHELL="Bild01-Bild16_stack_ldr_0002.tif"
LDR_STACK_2_INPUT=Bild01-Bild16_exposure_layers_0002.tif
LDR_STACK_2_INPUT_SHELL="Bild01-Bild16_exposure_layers_0002.tif"
LDR_STACK_3=Bild01-Bild16_stack_ldr_0003.tif
LDR_STACK_3_SHELL="Bild01-Bild16_stack_ldr_0003.tif"
LDR_STACK_3_INPUT=Bild01-Bild16_exposure_layers_0003.tif
LDR_STACK_3_INPUT_SHELL="Bild01-Bild16_exposure_layers_0003.tif"
LDR_STACK_4=Bild01-Bild16_stack_ldr_0004.tif
LDR_STACK_4_SHELL="Bild01-Bild16_stack_ldr_0004.tif"
LDR_STACK_4_INPUT=Bild01-Bild16_exposure_layers_0004.tif
LDR_STACK_4_INPUT_SHELL="Bild01-Bild16_exposure_layers_0004.tif"
LDR_STACK_5=Bild01-Bild16_stack_ldr_0005.tif
LDR_STACK_5_SHELL="Bild01-Bild16_stack_ldr_0005.tif"
LDR_STACK_5_INPUT=Bild01-Bild16_exposure_layers_0005.tif
LDR_STACK_5_INPUT_SHELL="Bild01-Bild16_exposure_layers_0005.tif"
LDR_STACK_6=Bild01-Bild16_stack_ldr_0006.tif
LDR_STACK_6_SHELL="Bild01-Bild16_stack_ldr_0006.tif"
LDR_STACK_6_INPUT=Bild01-Bild16_exposure_layers_0006.tif
LDR_STACK_6_INPUT_SHELL="Bild01-Bild16_exposure_layers_0006.tif"
LDR_STACK_7=Bild01-Bild16_stack_ldr_0007.tif
LDR_STACK_7_SHELL="Bild01-Bild16_stack_ldr_0007.tif"
LDR_STACK_7_INPUT=Bild01-Bild16_exposure_layers_0007.tif
LDR_STACK_7_INPUT_SHELL="Bild01-Bild16_exposure_layers_0007.tif"
LDR_STACK_8=Bild01-Bild16_stack_ldr_0008.tif
LDR_STACK_8_SHELL="Bild01-Bild16_stack_ldr_0008.tif"
LDR_STACK_8_INPUT=Bild01-Bild16_exposure_layers_0008.tif
LDR_STACK_8_INPUT_SHELL="Bild01-Bild16_exposure_layers_0008.tif"
LDR_STACK_9=Bild01-Bild16_stack_ldr_0009.tif
LDR_STACK_9_SHELL="Bild01-Bild16_stack_ldr_0009.tif"
LDR_STACK_9_INPUT=Bild01-Bild16_exposure_layers_0009.tif
LDR_STACK_9_INPUT_SHELL="Bild01-Bild16_exposure_layers_0009.tif"
LDR_STACK_10=Bild01-Bild16_stack_ldr_0010.tif
LDR_STACK_10_SHELL="Bild01-Bild16_stack_ldr_0010.tif"
LDR_STACK_10_INPUT=Bild01-Bild16_exposure_layers_0010.tif
LDR_STACK_10_INPUT_SHELL="Bild01-Bild16_exposure_layers_0010.tif"
LDR_STACK_11=Bild01-Bild16_stack_ldr_0011.tif
LDR_STACK_11_SHELL="Bild01-Bild16_stack_ldr_0011.tif"
LDR_STACK_11_INPUT=Bild01-Bild16_exposure_layers_0011.tif
LDR_STACK_11_INPUT_SHELL="Bild01-Bild16_exposure_layers_0011.tif"
LDR_STACK_12=Bild01-Bild16_stack_ldr_0012.tif
LDR_STACK_12_SHELL="Bild01-Bild16_stack_ldr_0012.tif"
LDR_STACK_12_INPUT=Bild01-Bild16_exposure_layers_0012.tif
LDR_STACK_12_INPUT_SHELL="Bild01-Bild16_exposure_layers_0012.tif"
LDR_STACK_13=Bild01-Bild16_stack_ldr_0013.tif
LDR_STACK_13_SHELL="Bild01-Bild16_stack_ldr_0013.tif"
LDR_STACK_13_INPUT=Bild01-Bild16_exposure_layers_0013.tif
LDR_STACK_13_INPUT_SHELL="Bild01-Bild16_exposure_layers_0013.tif"
LDR_STACKS_NUMBERS=0 1 2 3 4 5 6 7 8 9 10 11 12 13 
LDR_STACKS=$(LDR_STACK_0) $(LDR_STACK_1) $(LDR_STACK_2) $(LDR_STACK_3) $(LDR_STACK_4) $(LDR_STACK_5) $(LDR_STACK_6) $(LDR_STACK_7) $(LDR_STACK_8) $(LDR_STACK_9) $(LDR_STACK_10) $(LDR_STACK_11) $(LDR_STACK_12) $(LDR_STACK_13) 
LDR_STACKS_SHELL=$(LDR_STACK_0_SHELL) $(LDR_STACK_1_SHELL) $(LDR_STACK_2_SHELL) $(LDR_STACK_3_SHELL) $(LDR_STACK_4_SHELL) $(LDR_STACK_5_SHELL) $(LDR_STACK_6_SHELL) $(LDR_STACK_7_SHELL) $(LDR_STACK_8_SHELL) $(LDR_STACK_9_SHELL) $(LDR_STACK_10_SHELL) $(LDR_STACK_11_SHELL) $(LDR_STACK_12_SHELL) $(LDR_STACK_13_SHELL) 
DO_LDR_BLENDED=1

all : startStitching $(LDR_BLENDED) 

startStitching : 
	@echo ===========================================================================
	@echo Stitching panorama
	@echo ===========================================================================

clean : 
	@echo ===========================================================================
	@echo Remove temporary files
	@echo ===========================================================================
	-$(RM) $(LDR_LAYERS_SHELL) 

test : 
	@echo ===========================================================================
	@echo Testing programs
	@echo ===========================================================================
	@echo Checking nona...
	@-$(NONA) --help > NUL 2>&1 && echo nona is ok || echo nona failed
	@echo Checking enblend...
	@-$(ENBLEND) -h > NUL 2>&1 && echo enblend is ok || echo enblend failed
	@echo Checking enfuse...
	@-$(ENFUSE) -h > NUL 2>&1 && echo enfuse is ok || echo enfuse failed
	@echo Checking hugin_hdrmerge...
	@-$(HDRMERGE) -h > NUL 2>&1 && echo hugin_hdrmerge is ok || echo hugin_hdrmerge failed
	@echo Checking exiftool...
	@-$(EXIFTOOL) -ver > NUL 2>&1 && echo exiftool is ok || echo exiftool failed

info : 
	@echo ===========================================================================
	@echo ***************  Panorama makefile generated by Hugin       ***************
	@echo ===========================================================================
	@echo System information
	@echo ===========================================================================
	@echo Operating System: Windows (6.2 )
	@echo Architecture: AMD64
	@echo Number of logical processors: 4
	@echo Physical memory: 8243884 kiB (33%% occupied)
	@echo Free space on disc: 315296 MiB
	@echo Active codepage: 1252 (Western European Windows)
	@echo ===========================================================================
	@echo Output options
	@echo ===========================================================================
	@echo Hugin Version: 2012.0.0.a6e4184ad538 built by Matthew Petroff
	@echo Project file: D:\Panoramen\test_halle\Bild01-Bild16.pto
	@echo Output prefix: Bild01-Bild16
	@echo Projection: Equirectangular (2)
	@echo Field of view: 360 x 180
	@echo Canvas dimensions: 5000 x 2500
	@echo Crop area: (0,0) - (5000,2500)
	@echo Output exposure value: 0.04
	@echo Selected outputs
	@echo Normal panorama
	@echo * Blended panorama
	@echo Using GPU for remapping
	@echo ===========================================================================
	@echo Input images
	@echo ===========================================================================
	@echo Number of images in project file: 14
	@echo Number of active images: 14
	@echo Image 0: D:\Panoramen\test_halle\Bild01.jpg
	@echo Image 0: Size 1333x2000, Exposure: 0.00
	@echo Image 1: D:\Panoramen\test_halle\Bild02.jpg
	@echo Image 1: Size 1333x2000, Exposure: 0.01
	@echo Image 2: D:\Panoramen\test_halle\Bild03.jpg
	@echo Image 2: Size 1333x2000, Exposure: 0.05
	@echo Image 3: D:\Panoramen\test_halle\Bild04.jpg
	@echo Image 3: Size 1333x2000, Exposure: 0.11
	@echo Image 4: D:\Panoramen\test_halle\Bild05.jpg
	@echo Image 4: Size 1333x2000, Exposure: 0.07
	@echo Image 5: D:\Panoramen\test_halle\Bild06.jpg
	@echo Image 5: Size 1333x2000, Exposure: 0.01
	@echo Image 6: D:\Panoramen\test_halle\Bild07.jpg
	@echo Image 6: Size 1333x2000, Exposure: 0.06
	@echo Image 7: D:\Panoramen\test_halle\Bild08.jpg
	@echo Image 7: Size 1333x2000, Exposure: -0.07
	@echo Image 8: D:\Panoramen\test_halle\Bild09.jpg
	@echo Image 8: Size 1333x2000, Exposure: 0.04
	@echo Image 9: D:\Panoramen\test_halle\Bild10.jpg
	@echo Image 9: Size 1333x2000, Exposure: 0.09
	@echo Image 10: D:\Panoramen\test_halle\Bild11.jpg
	@echo Image 10: Size 1333x2000, Exposure: 0.10
	@echo Image 11: D:\Panoramen\test_halle\Bild12.jpg
	@echo Image 11: Size 1333x2000, Exposure: -0.06
	@echo Image 12: D:\Panoramen\test_halle\Bild13.jpg
	@echo Image 12: Size 1333x2000, Exposure: 0.04
	@echo Image 13: D:\Panoramen\test_halle\Bild14.jpg
	@echo Image 13: Size 1333x2000, Exposure: 0.09

# Rules for ordinary TIFF_m and hdr output

Bild01-Bild160000.tif : D:/Panoramen/test_halle/Bild01.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) $(NONA_LDR_REMAPPED_COMP) -r ldr -m TIFF_m -o $(LDR_REMAPPED_PREFIX_SHELL) -i 0 $(PROJECT_FILE_SHELL)

Bild01-Bild16_hdr_0000.exr : D:/Panoramen/test_halle/Bild01.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) -r hdr -m EXR_m -o $(HDR_STACK_REMAPPED_PREFIX_SHELL) -i 0 $(PROJECT_FILE_SHELL)

Bild01-Bild160001.tif : D:/Panoramen/test_halle/Bild02.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) $(NONA_LDR_REMAPPED_COMP) -r ldr -m TIFF_m -o $(LDR_REMAPPED_PREFIX_SHELL) -i 1 $(PROJECT_FILE_SHELL)

Bild01-Bild16_hdr_0001.exr : D:/Panoramen/test_halle/Bild02.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) -r hdr -m EXR_m -o $(HDR_STACK_REMAPPED_PREFIX_SHELL) -i 1 $(PROJECT_FILE_SHELL)

Bild01-Bild160002.tif : D:/Panoramen/test_halle/Bild03.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) $(NONA_LDR_REMAPPED_COMP) -r ldr -m TIFF_m -o $(LDR_REMAPPED_PREFIX_SHELL) -i 2 $(PROJECT_FILE_SHELL)

Bild01-Bild16_hdr_0002.exr : D:/Panoramen/test_halle/Bild03.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) -r hdr -m EXR_m -o $(HDR_STACK_REMAPPED_PREFIX_SHELL) -i 2 $(PROJECT_FILE_SHELL)

Bild01-Bild160003.tif : D:/Panoramen/test_halle/Bild04.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) $(NONA_LDR_REMAPPED_COMP) -r ldr -m TIFF_m -o $(LDR_REMAPPED_PREFIX_SHELL) -i 3 $(PROJECT_FILE_SHELL)

Bild01-Bild16_hdr_0003.exr : D:/Panoramen/test_halle/Bild04.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) -r hdr -m EXR_m -o $(HDR_STACK_REMAPPED_PREFIX_SHELL) -i 3 $(PROJECT_FILE_SHELL)

Bild01-Bild160004.tif : D:/Panoramen/test_halle/Bild05.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) $(NONA_LDR_REMAPPED_COMP) -r ldr -m TIFF_m -o $(LDR_REMAPPED_PREFIX_SHELL) -i 4 $(PROJECT_FILE_SHELL)

Bild01-Bild16_hdr_0004.exr : D:/Panoramen/test_halle/Bild05.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) -r hdr -m EXR_m -o $(HDR_STACK_REMAPPED_PREFIX_SHELL) -i 4 $(PROJECT_FILE_SHELL)

Bild01-Bild160005.tif : D:/Panoramen/test_halle/Bild06.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) $(NONA_LDR_REMAPPED_COMP) -r ldr -m TIFF_m -o $(LDR_REMAPPED_PREFIX_SHELL) -i 5 $(PROJECT_FILE_SHELL)

Bild01-Bild16_hdr_0005.exr : D:/Panoramen/test_halle/Bild06.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) -r hdr -m EXR_m -o $(HDR_STACK_REMAPPED_PREFIX_SHELL) -i 5 $(PROJECT_FILE_SHELL)

Bild01-Bild160006.tif : D:/Panoramen/test_halle/Bild07.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) $(NONA_LDR_REMAPPED_COMP) -r ldr -m TIFF_m -o $(LDR_REMAPPED_PREFIX_SHELL) -i 6 $(PROJECT_FILE_SHELL)

Bild01-Bild16_hdr_0006.exr : D:/Panoramen/test_halle/Bild07.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) -r hdr -m EXR_m -o $(HDR_STACK_REMAPPED_PREFIX_SHELL) -i 6 $(PROJECT_FILE_SHELL)

Bild01-Bild160007.tif : D:/Panoramen/test_halle/Bild08.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) $(NONA_LDR_REMAPPED_COMP) -r ldr -m TIFF_m -o $(LDR_REMAPPED_PREFIX_SHELL) -i 7 $(PROJECT_FILE_SHELL)

Bild01-Bild16_hdr_0007.exr : D:/Panoramen/test_halle/Bild08.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) -r hdr -m EXR_m -o $(HDR_STACK_REMAPPED_PREFIX_SHELL) -i 7 $(PROJECT_FILE_SHELL)

Bild01-Bild160008.tif : D:/Panoramen/test_halle/Bild09.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) $(NONA_LDR_REMAPPED_COMP) -r ldr -m TIFF_m -o $(LDR_REMAPPED_PREFIX_SHELL) -i 8 $(PROJECT_FILE_SHELL)

Bild01-Bild16_hdr_0008.exr : D:/Panoramen/test_halle/Bild09.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) -r hdr -m EXR_m -o $(HDR_STACK_REMAPPED_PREFIX_SHELL) -i 8 $(PROJECT_FILE_SHELL)

Bild01-Bild160009.tif : D:/Panoramen/test_halle/Bild10.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) $(NONA_LDR_REMAPPED_COMP) -r ldr -m TIFF_m -o $(LDR_REMAPPED_PREFIX_SHELL) -i 9 $(PROJECT_FILE_SHELL)

Bild01-Bild16_hdr_0009.exr : D:/Panoramen/test_halle/Bild10.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) -r hdr -m EXR_m -o $(HDR_STACK_REMAPPED_PREFIX_SHELL) -i 9 $(PROJECT_FILE_SHELL)

Bild01-Bild160010.tif : D:/Panoramen/test_halle/Bild11.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) $(NONA_LDR_REMAPPED_COMP) -r ldr -m TIFF_m -o $(LDR_REMAPPED_PREFIX_SHELL) -i 10 $(PROJECT_FILE_SHELL)

Bild01-Bild16_hdr_0010.exr : D:/Panoramen/test_halle/Bild11.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) -r hdr -m EXR_m -o $(HDR_STACK_REMAPPED_PREFIX_SHELL) -i 10 $(PROJECT_FILE_SHELL)

Bild01-Bild160011.tif : D:/Panoramen/test_halle/Bild12.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) $(NONA_LDR_REMAPPED_COMP) -r ldr -m TIFF_m -o $(LDR_REMAPPED_PREFIX_SHELL) -i 11 $(PROJECT_FILE_SHELL)

Bild01-Bild16_hdr_0011.exr : D:/Panoramen/test_halle/Bild12.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) -r hdr -m EXR_m -o $(HDR_STACK_REMAPPED_PREFIX_SHELL) -i 11 $(PROJECT_FILE_SHELL)

Bild01-Bild160012.tif : D:/Panoramen/test_halle/Bild13.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) $(NONA_LDR_REMAPPED_COMP) -r ldr -m TIFF_m -o $(LDR_REMAPPED_PREFIX_SHELL) -i 12 $(PROJECT_FILE_SHELL)

Bild01-Bild16_hdr_0012.exr : D:/Panoramen/test_halle/Bild13.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) -r hdr -m EXR_m -o $(HDR_STACK_REMAPPED_PREFIX_SHELL) -i 12 $(PROJECT_FILE_SHELL)

Bild01-Bild160013.tif : D:/Panoramen/test_halle/Bild14.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) $(NONA_LDR_REMAPPED_COMP) -r ldr -m TIFF_m -o $(LDR_REMAPPED_PREFIX_SHELL) -i 13 $(PROJECT_FILE_SHELL)

Bild01-Bild16_hdr_0013.exr : D:/Panoramen/test_halle/Bild14.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) -r hdr -m EXR_m -o $(HDR_STACK_REMAPPED_PREFIX_SHELL) -i 13 $(PROJECT_FILE_SHELL)

# Rules for exposure layer output

Bild01-Bild16_exposure_layers_0000.tif : D:/Panoramen/test_halle/Bild01.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) $(NONA_LDR_REMAPPED_COMP) -r ldr -e 0 -m TIFF_m -o $(LDR_EXPOSURE_REMAPPED_PREFIX_SHELL) -i 0 $(PROJECT_FILE_SHELL)

Bild01-Bild16_exposure_layers_0001.tif : D:/Panoramen/test_halle/Bild02.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) $(NONA_LDR_REMAPPED_COMP) -r ldr -e 0.00849545 -m TIFF_m -o $(LDR_EXPOSURE_REMAPPED_PREFIX_SHELL) -i 1 $(PROJECT_FILE_SHELL)

Bild01-Bild16_exposure_layers_0002.tif : D:/Panoramen/test_halle/Bild03.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) $(NONA_LDR_REMAPPED_COMP) -r ldr -e 0.0467744 -m TIFF_m -o $(LDR_EXPOSURE_REMAPPED_PREFIX_SHELL) -i 2 $(PROJECT_FILE_SHELL)

Bild01-Bild16_exposure_layers_0003.tif : D:/Panoramen/test_halle/Bild04.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) $(NONA_LDR_REMAPPED_COMP) -r ldr -e 0.111645 -m TIFF_m -o $(LDR_EXPOSURE_REMAPPED_PREFIX_SHELL) -i 3 $(PROJECT_FILE_SHELL)

Bild01-Bild16_exposure_layers_0004.tif : D:/Panoramen/test_halle/Bild05.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) $(NONA_LDR_REMAPPED_COMP) -r ldr -e 0.0689551 -m TIFF_m -o $(LDR_EXPOSURE_REMAPPED_PREFIX_SHELL) -i 4 $(PROJECT_FILE_SHELL)

Bild01-Bild16_exposure_layers_0005.tif : D:/Panoramen/test_halle/Bild06.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) $(NONA_LDR_REMAPPED_COMP) -r ldr -e 0.00613086 -m TIFF_m -o $(LDR_EXPOSURE_REMAPPED_PREFIX_SHELL) -i 5 $(PROJECT_FILE_SHELL)

Bild01-Bild16_exposure_layers_0006.tif : D:/Panoramen/test_halle/Bild07.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) $(NONA_LDR_REMAPPED_COMP) -r ldr -e 0.0645172 -m TIFF_m -o $(LDR_EXPOSURE_REMAPPED_PREFIX_SHELL) -i 6 $(PROJECT_FILE_SHELL)

Bild01-Bild16_exposure_layers_0007.tif : D:/Panoramen/test_halle/Bild08.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) $(NONA_LDR_REMAPPED_COMP) -r ldr -e -0.0732121 -m TIFF_m -o $(LDR_EXPOSURE_REMAPPED_PREFIX_SHELL) -i 7 $(PROJECT_FILE_SHELL)

Bild01-Bild16_exposure_layers_0008.tif : D:/Panoramen/test_halle/Bild09.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) $(NONA_LDR_REMAPPED_COMP) -r ldr -e 0.0392506 -m TIFF_m -o $(LDR_EXPOSURE_REMAPPED_PREFIX_SHELL) -i 8 $(PROJECT_FILE_SHELL)

Bild01-Bild16_exposure_layers_0009.tif : D:/Panoramen/test_halle/Bild10.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) $(NONA_LDR_REMAPPED_COMP) -r ldr -e 0.0943236 -m TIFF_m -o $(LDR_EXPOSURE_REMAPPED_PREFIX_SHELL) -i 9 $(PROJECT_FILE_SHELL)

Bild01-Bild16_exposure_layers_0010.tif : D:/Panoramen/test_halle/Bild11.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) $(NONA_LDR_REMAPPED_COMP) -r ldr -e 0.10336 -m TIFF_m -o $(LDR_EXPOSURE_REMAPPED_PREFIX_SHELL) -i 10 $(PROJECT_FILE_SHELL)

Bild01-Bild16_exposure_layers_0011.tif : D:/Panoramen/test_halle/Bild12.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) $(NONA_LDR_REMAPPED_COMP) -r ldr -e -0.0635119 -m TIFF_m -o $(LDR_EXPOSURE_REMAPPED_PREFIX_SHELL) -i 11 $(PROJECT_FILE_SHELL)

Bild01-Bild16_exposure_layers_0012.tif : D:/Panoramen/test_halle/Bild13.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) $(NONA_LDR_REMAPPED_COMP) -r ldr -e 0.0408652 -m TIFF_m -o $(LDR_EXPOSURE_REMAPPED_PREFIX_SHELL) -i 12 $(PROJECT_FILE_SHELL)

Bild01-Bild16_exposure_layers_0013.tif : D:/Panoramen/test_halle/Bild14.jpg $(PROJECT_FILE) 
	$(NONA) $(NONA_OPTS) $(NONA_LDR_REMAPPED_COMP) -r ldr -e 0.0900783 -m TIFF_m -o $(LDR_EXPOSURE_REMAPPED_PREFIX_SHELL) -i 13 $(PROJECT_FILE_SHELL)

# Rules for LDR and HDR stack merging, a rule for each stack

$(LDR_STACK_0) : $(LDR_STACK_0_INPUT) 
	$(ENFUSE) $(ENFUSE_OPTS) -o $(LDR_STACK_0_SHELL) -- $(LDR_STACK_0_INPUT_SHELL)
	-$(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_STACK_0_SHELL)

$(HDR_STACK_0) : $(HDR_STACK_0_INPUT) 
	$(HDRMERGE) $(HDRMERGE_OPTS) -o $(HDR_STACK_0_SHELL) -- $(HDR_STACK_0_INPUT_SHELL)

$(LDR_STACK_1) : $(LDR_STACK_1_INPUT) 
	$(ENFUSE) $(ENFUSE_OPTS) -o $(LDR_STACK_1_SHELL) -- $(LDR_STACK_1_INPUT_SHELL)
	-$(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_STACK_1_SHELL)

$(HDR_STACK_1) : $(HDR_STACK_1_INPUT) 
	$(HDRMERGE) $(HDRMERGE_OPTS) -o $(HDR_STACK_1_SHELL) -- $(HDR_STACK_1_INPUT_SHELL)

$(LDR_STACK_2) : $(LDR_STACK_2_INPUT) 
	$(ENFUSE) $(ENFUSE_OPTS) -o $(LDR_STACK_2_SHELL) -- $(LDR_STACK_2_INPUT_SHELL)
	-$(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_STACK_2_SHELL)

$(HDR_STACK_2) : $(HDR_STACK_2_INPUT) 
	$(HDRMERGE) $(HDRMERGE_OPTS) -o $(HDR_STACK_2_SHELL) -- $(HDR_STACK_2_INPUT_SHELL)

$(LDR_STACK_3) : $(LDR_STACK_3_INPUT) 
	$(ENFUSE) $(ENFUSE_OPTS) -o $(LDR_STACK_3_SHELL) -- $(LDR_STACK_3_INPUT_SHELL)
	-$(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_STACK_3_SHELL)

$(HDR_STACK_3) : $(HDR_STACK_3_INPUT) 
	$(HDRMERGE) $(HDRMERGE_OPTS) -o $(HDR_STACK_3_SHELL) -- $(HDR_STACK_3_INPUT_SHELL)

$(LDR_STACK_4) : $(LDR_STACK_4_INPUT) 
	$(ENFUSE) $(ENFUSE_OPTS) -o $(LDR_STACK_4_SHELL) -- $(LDR_STACK_4_INPUT_SHELL)
	-$(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_STACK_4_SHELL)

$(HDR_STACK_4) : $(HDR_STACK_4_INPUT) 
	$(HDRMERGE) $(HDRMERGE_OPTS) -o $(HDR_STACK_4_SHELL) -- $(HDR_STACK_4_INPUT_SHELL)

$(LDR_STACK_5) : $(LDR_STACK_5_INPUT) 
	$(ENFUSE) $(ENFUSE_OPTS) -o $(LDR_STACK_5_SHELL) -- $(LDR_STACK_5_INPUT_SHELL)
	-$(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_STACK_5_SHELL)

$(HDR_STACK_5) : $(HDR_STACK_5_INPUT) 
	$(HDRMERGE) $(HDRMERGE_OPTS) -o $(HDR_STACK_5_SHELL) -- $(HDR_STACK_5_INPUT_SHELL)

$(LDR_STACK_6) : $(LDR_STACK_6_INPUT) 
	$(ENFUSE) $(ENFUSE_OPTS) -o $(LDR_STACK_6_SHELL) -- $(LDR_STACK_6_INPUT_SHELL)
	-$(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_STACK_6_SHELL)

$(HDR_STACK_6) : $(HDR_STACK_6_INPUT) 
	$(HDRMERGE) $(HDRMERGE_OPTS) -o $(HDR_STACK_6_SHELL) -- $(HDR_STACK_6_INPUT_SHELL)

$(LDR_STACK_7) : $(LDR_STACK_7_INPUT) 
	$(ENFUSE) $(ENFUSE_OPTS) -o $(LDR_STACK_7_SHELL) -- $(LDR_STACK_7_INPUT_SHELL)
	-$(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_STACK_7_SHELL)

$(HDR_STACK_7) : $(HDR_STACK_7_INPUT) 
	$(HDRMERGE) $(HDRMERGE_OPTS) -o $(HDR_STACK_7_SHELL) -- $(HDR_STACK_7_INPUT_SHELL)

$(LDR_STACK_8) : $(LDR_STACK_8_INPUT) 
	$(ENFUSE) $(ENFUSE_OPTS) -o $(LDR_STACK_8_SHELL) -- $(LDR_STACK_8_INPUT_SHELL)
	-$(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_STACK_8_SHELL)

$(HDR_STACK_8) : $(HDR_STACK_8_INPUT) 
	$(HDRMERGE) $(HDRMERGE_OPTS) -o $(HDR_STACK_8_SHELL) -- $(HDR_STACK_8_INPUT_SHELL)

$(LDR_STACK_9) : $(LDR_STACK_9_INPUT) 
	$(ENFUSE) $(ENFUSE_OPTS) -o $(LDR_STACK_9_SHELL) -- $(LDR_STACK_9_INPUT_SHELL)
	-$(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_STACK_9_SHELL)

$(HDR_STACK_9) : $(HDR_STACK_9_INPUT) 
	$(HDRMERGE) $(HDRMERGE_OPTS) -o $(HDR_STACK_9_SHELL) -- $(HDR_STACK_9_INPUT_SHELL)

$(LDR_STACK_10) : $(LDR_STACK_10_INPUT) 
	$(ENFUSE) $(ENFUSE_OPTS) -o $(LDR_STACK_10_SHELL) -- $(LDR_STACK_10_INPUT_SHELL)
	-$(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_STACK_10_SHELL)

$(HDR_STACK_10) : $(HDR_STACK_10_INPUT) 
	$(HDRMERGE) $(HDRMERGE_OPTS) -o $(HDR_STACK_10_SHELL) -- $(HDR_STACK_10_INPUT_SHELL)

$(LDR_STACK_11) : $(LDR_STACK_11_INPUT) 
	$(ENFUSE) $(ENFUSE_OPTS) -o $(LDR_STACK_11_SHELL) -- $(LDR_STACK_11_INPUT_SHELL)
	-$(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_STACK_11_SHELL)

$(HDR_STACK_11) : $(HDR_STACK_11_INPUT) 
	$(HDRMERGE) $(HDRMERGE_OPTS) -o $(HDR_STACK_11_SHELL) -- $(HDR_STACK_11_INPUT_SHELL)

$(LDR_STACK_12) : $(LDR_STACK_12_INPUT) 
	$(ENFUSE) $(ENFUSE_OPTS) -o $(LDR_STACK_12_SHELL) -- $(LDR_STACK_12_INPUT_SHELL)
	-$(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_STACK_12_SHELL)

$(HDR_STACK_12) : $(HDR_STACK_12_INPUT) 
	$(HDRMERGE) $(HDRMERGE_OPTS) -o $(HDR_STACK_12_SHELL) -- $(HDR_STACK_12_INPUT_SHELL)

$(LDR_STACK_13) : $(LDR_STACK_13_INPUT) 
	$(ENFUSE) $(ENFUSE_OPTS) -o $(LDR_STACK_13_SHELL) -- $(LDR_STACK_13_INPUT_SHELL)
	-$(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_STACK_13_SHELL)

$(HDR_STACK_13) : $(HDR_STACK_13_INPUT) 
	$(HDRMERGE) $(HDRMERGE_OPTS) -o $(HDR_STACK_13_SHELL) -- $(HDR_STACK_13_INPUT_SHELL)

$(LDR_BLENDED) : $(LDR_LAYERS) 
	$(ENBLEND) $(ENBLEND_LDR_COMP) $(ENBLEND_OPTS) -o $(LDR_BLENDED_SHELL) -- $(LDR_LAYERS_SHELL)
	-$(EXIFTOOL) -E -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(EXIFTOOL_INFO_ARGS) $(LDR_BLENDED_SHELL)

$(LDR_EXPOSURE_LAYER_0) : $(LDR_EXPOSURE_LAYER_0_INPUT) 
	$(ENBLEND) $(ENBLEND_EXPOSURE_COMP) $(ENBLEND_OPTS) -o $(LDR_EXPOSURE_LAYER_0_SHELL) -- $(LDR_EXPOSURE_LAYER_0_INPUT_SHELL)
	-$(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_EXPOSURE_LAYER_0_SHELL)

$(LDR_STACKED_BLENDED) : $(LDR_STACKS) 
	$(ENBLEND) $(ENBLEND_LDR_COMP) $(ENBLEND_OPTS) -o $(LDR_STACKED_BLENDED_SHELL) -- $(LDR_STACKS_SHELL)
	-$(EXIFTOOL) -E -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(EXIFTOOL_INFO_ARGS) $(LDR_STACKED_BLENDED_SHELL)

$(LDR_EXPOSURE_LAYERS_FUSED) : $(LDR_EXPOSURE_LAYERS) 
	$(ENFUSE) $(ENBLEND_LDR_COMP) $(ENFUSE_OPTS) -o $(LDR_EXPOSURE_LAYERS_FUSED_SHELL) -- $(LDR_EXPOSURE_LAYERS_SHELL)
	-$(EXIFTOOL) -E -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(EXIFTOOL_INFO_ARGS) $(LDR_EXPOSURE_LAYERS_FUSED_SHELL)

$(HDR_BLENDED) : $(HDR_STACKS) 
	$(ENBLEND) $(ENBLEND_HDR_COMP) $(ENBLEND_OPTS) -o $(HDR_BLENDED_SHELL) -- $(HDR_STACKS_SHELL)

$(LDR_REMAPPED_PREFIX)_multilayer.tif : $(LDR_LAYERS) 
	tiffcp $(LDR_LAYERS_SHELL) $(LDR_REMAPPED_PREFIX_SHELL)_multilayer.tif

$(LDR_REMAPPED_PREFIX)_fused_multilayer.tif : $(LDR_STACKS) $(LDR_EXPOSURE_LAYERS) 
	tiffcp $(LDR_STACKS_SHELL) $(LDR_EXPOSURE_LAYERS_SHELL) $(LDR_REMAPPED_PREFIX_SHELL)_fused_multilayer.tif

$(LDR_REMAPPED_PREFIX)_multilayer.psd : $(LDR_LAYERS) 
	PTtiff2psd -o $(LDR_REMAPPED_PREFIX_SHELL)_multilayer.psd $(LDR_LAYERS_SHELL)

$(LDR_REMAPPED_PREFIX)_fused_multilayer.psd : $(LDR_STACKS) $(LDR_EXPOSURE_LAYERS) 
	PTtiff2psd -o $(LDR_REMAPPED_PREFIX_SHELL)_fused_multilayer.psd $(LDR_STACKS_SHELL)$(LDR_EXPOSURE_LAYERS_SHELL)
